//%attributes = {"publishedSql":true}
// Method: _doc_ Zip
// 2007.02.27-18:28:54 / Pasi Mankinen
// © Copyright 2007 Manage Applications
// Purpose: 
// 
// http://sources.4d.com/trac/4d_keisuke/wiki/Components/7-Zip
// ------------------------------------------------------------
C_LONGINT:C283($0; $_doc_lErr; $1; $_doc_lAction; $_doc_lOk; $_doc_lIndex)
C_TEXT:C284($2; $_doc_tPath; $3; $_doc_tExtraParams; $4; $_doc_tPassword; _doc_tZipResult; $_doc_tFolderName; $_doc_tDocName)
C_TEXT:C284($_doc_tDocFolder; $_doc_tInputParameters; $_doc_tZipUnzipParameters; $_doc_tErr)
C_TIME:C306($_doc_hDoc)

COMPILER__doc

$_doc_lAction:=$1
$_doc_tPath:=""
$_doc_tExtraParams:=""
$_doc_tPassword:=""
If (Count parameters:C259>1)
	$_doc_tPath:=$2
	If (Count parameters:C259>2)
		$_doc_tExtraParams:=$3
		If (Count parameters:C259>3)
			$_doc_tPassword:=$4
		End if 
	End if 
End if 
$_doc_lErr:=0

$_doc_tPath:=Replace string:C233($_doc_tPath; "{localpath}"; _doc LocalPath)

Case of 
	: ($_doc_lAction=kCreate)
		_doc_tZipResult:=""
		_doc_tZipDestinationFile:=""
		_doc_tZipSourceFiles:=""
		$_doc_tDocName:=_doc NameGet($_doc_tPath)
		$_doc_tDocFolder:=_doc FolderGet($_doc_tPath)
		OK:=1
		If (Test path name:C476($_doc_tDocFolder)#Is a folder:K24:2)  //try to create a new document
			$_doc_tDocFolder:=_doc FolderChoose(_lang Current("Zip document path is not valid. Choose a new path"); $_doc_tDocFolder)
		End if 
		
		If (OK=0)
			$_doc_lErr:=-1  // folder does not exist  
		Else 
			If (Test path name:C476($_doc_tDocFolder+$_doc_tDocName)=Is a document:K24:1)
				$_doc_lErr:=-2
				_err MESSAGE(_lang Current("Error when creating zip file. File already exists")+": "+$_doc_tDocFolder+$_doc_tDocName; Current method name:C684; kFalse)
			Else 
				_doc_tZipDestinationFile:=$_doc_tDocFolder+$_doc_tDocName
			End if 
		End if 
		
	: ($_doc_lAction=kInit)
		_doc_tZipResult:=""
		_doc_tZipDestinationFile:=""
		_doc_tZipSourceFiles:=""
		
	: ($_doc_lAction=kAdd)
		
		//If (_doc_tZipSourceFiles#"")
		//_doc_tZipSourceFiles:=_doc_tZipSourceFiles+Char(0)  // Char(0) can not be part of file name, is file name separator
		//End if 
		_doc_tZipSourceFiles:=_doc_tZipSourceFiles+$_doc_tPath+Char:C90(0)
		
	: ($_doc_lAction=kEncode)
		
		If (Test path name:C476($_doc_tPath)=Is a document:K24:1)
			_doc_tZipDestinationFile:=$_doc_tPath
		End if 
		
		// $success_b:=z7_Archive ($source_path_t;_doc_tZipDestinationFile;$password_t{;->$error_t}})
		If (_doc_7zArchiveFiles(_doc_tZipSourceFiles; _doc_tZipDestinationFile; $_doc_tPassword; ->$_doc_tErr)=False:C215)
			$_doc_lErr:=-1
			_err MESSAGE(_lang Current("Error when compressing files")+ksSpace+ksQuoteSingle+Replace string:C233(_doc_tZipSourceFiles; Char:C90(0); ksQuoteSingle+ksSpace+ksQuoteSingle; *)\
				+ksQuoteSingle+ksSpace+_lang Current("to zip file")+ksSpace+_doc_tZipDestinationFile+": "+$_doc_tErr; Current method name:C684; kFalse)
		End if 
		_doc_tZipSourceFiles:=""
		
	: ($_doc_lAction=kDecode)
		
		// $success_b:=z7_Extract ($source_archive_file_path_t;$destination_directory_path_t{;$password_t{;->$error_t}})
		If (_doc_tZipSourceFiles="")
			// extract full zip
			If (z7_Extract($_doc_tPath; $_doc_tExtraParams; $_doc_tPassword; ->$_doc_tErr)=False:C215)  // uses component 7-Zip.4dbase
				$_doc_lErr:=-1
				_err MESSAGE(_lang Current("Error when decompressing zip file")+ksSpace+ksQuoteSingle+$_doc_tPath+ksQuoteSingle\
					+ksSpace+_lang Current("to folder")+ksSpace+ksQuoteSingle+$_doc_tExtraParams+ksQuoteSingle+ksSpace+": "+ksCR+$_doc_tErr; Current method name:C684; kFalse)
			End if 
		Else 
			// extract only some files from zip
			If (_doc_7zExtractFiles($_doc_tPath; $_doc_tExtraParams; $_doc_tPassword; ->$_doc_tErr; _doc_tZipSourceFiles)=False:C215)
				$_doc_lErr:=-1
				_err MESSAGE(_lang Current("Error when decompressing zip file")+ksSpace+ksQuoteSingle+$_doc_tPath+ksQuoteSingle\
					+ksSpace+ksQuoteSingle+Replace string:C233(_doc_tZipSourceFiles; Char:C90(0); ksQuoteSingle+ksSpace+ksQuoteSingle; *)\
					+ksQuoteSingle+ksSpace+_lang Current("to folder")+ksSpace+ksQuoteSingle+$_doc_tExtraParams+ksQuoteSingle+ksSpace+": "+ksCR+$_doc_tErr; Current method name:C684; kFalse)
			End if 
		End if 
		_doc_tZipSourceFiles:=""
		
	Else 
		_err MESSAGE_PARAMETER("$1"; Current method name:C684; kTrue)
End case 
$0:=$_doc_lErr
